//
//  OPProfile.h
//  OnePasswordiOS
//
//  Created by Roustem Karimov on 12-02-19.
//  Copyright (c) 2012 AgileBits. All rights reserved.
//
#import <Foundation/Foundation.h>

#import <OnePasswordCore/OnePasswordCore.h>

#import "OPDatabaseObjectWithOverview.h"
#import "OPGenericProfile.h"

NS_ASSUME_NONNULL_BEGIN

@class OPCategory;

@interface OPProfile : OPDatabaseObjectWithOverview <NSSecureCoding, OPGenericProfile>

@property (nonatomic, copy, nullable) NSString * profilePassword;
@property (nonatomic, copy, nullable) NSData * overviewKey;
@property (nonatomic, copy, nullable) NSData * masterKey;

@property (nonatomic, copy, nullable) NSString * predefinedIconName;

@property (nonatomic, copy) OPColor * profileColor;
@property (nonatomic, assign) BOOL tagsLoaded;

//
// database properties
//
@property (nonatomic, readonly, nullable) NSString * uuid;
@property (nonatomic) OPTimestamp createdAt;
@property (nonatomic) OPTimestamp updatedAt;

@property (nonatomic, strong) NSData * encryptedMasterKey;
@property (nonatomic, strong) NSData * encryptedOverviewKey;
@property (nonatomic, strong) NSData * salt;
@property (nonatomic) NSUInteger iterations;

@property (nonatomic, copy, nullable) NSString * passwordHint;
@property (nonatomic, strong, nullable) NSData * iconData;
@property (nonatomic, strong) NSString * profileColorText;
@property (nonatomic, copy) NSString * lastUpdatedBy;
@property (nonatomic, copy) NSString * profileName;
@property (nonatomic, strong) NSData * attributesData;

+ (OPProfile *)profileWithName:(NSString *)name password:(NSString *)password hint:(NSString *)hint;

+ (OPImage *)iconWithOverlayName:(nullable NSString *)overlayImageName color:(OPColor *)color colorSize:(CGFloat)colorSize innerImage:(nullable OPImage *)innerImage innerSize:(CGFloat)innerSize;
+ (OPImage *)mainLockIconWithColor:(OPColor *)color image:(OPImage *)image;
+ (OPImage *)helperLockIconWithColor:(OPColor *)color image:(OPImage *)image;
+ (OPImage *)mainToolbarIconWithColor:(OPColor *)color image:(OPImage *)image;
+ (OPImage *)helperToolbarIconWithColor:(OPColor *)color image:(OPImage *)image;
+ (OPImage *)menuIconWithColor:(OPColor *)color image:(OPImage *)image;
+ (OPImage *)syncPreferencesIconWithColor:(OPColor *)color image:(OPImage *)image;
+ (OPImage *)settingsIconWithColor:(OPColor *)color image:(OPImage *)image;
+ (OPImage *)sidebarIconWithColor:(OPColor *)color image:(OPImage *)image;

#if TARGET_OS_IPHONE
+ (OPImage *)navigationBarIconWithColor:(OPColor *)color image:(nullable OPImage *)image;
#endif

+ (NSString *)primaryProfileName;
+ (NSString *)demoProfileName;
+ (NSString *)displayedProfileNameForName:(NSString *)name;

- (id)initNewWithPassword:(NSString *)password;

- (NSString *)keychainFileName;

/*!
 * Use [OP4Database unlockProfile:withPassword:error:]
 */
- (BOOL)_unlockWithPassword:(NSString *)password;
- (BOOL)changePasswordTo:(NSString *)password;

- (NSData *)encryptItemKey:(OPAESKey *)itemKey;
- (OPAESKey *)decryptItemKey:(NSData *)rawKey;

- (NSData *)hmacForData:(NSData *)data;
- (NSString *)hmacForString:(NSString *)string;

- (NSData *)blob;
- (void)setBlob:(NSData *)blob;

- (BOOL)encryptAttributesWithPrimaryProfile:(OPProfile *)primaryProfile error:(NSError **)error;
- (BOOL)decryptAttributesWithPrimaryProfile:(OPProfile *)primaryProfile error:(NSError **)error;

- (void)_setUUID:(NSString *)uuid;

- (OPCategory *)categoryWithUUID:(NSString *)uuid;
- (void)addCategory:(OPCategory *)category;

- (OPCategory *)newLegacyCategoryWithUUID:(NSString *)categoryUUID; // Does not add the category to the profile automatically
- (OPCategory *)newCategoryFromTemplate:(OPTemplate *)template; // does not add the category to the profile automatically
- (OPCategory *)newSystemCategoryWithUUID:(nullable NSString *)categoryUUID; // Does not add the category to the profile automatically

- (Class)itemClassForCategoryUUID:(NSString *)categoryUUID;

@end

NS_ASSUME_NONNULL_END

